/*:
 * @plugindesc Using this Plugin allows you to customize the Window Skin used by each, individual Window in your game.
 * @author SumRndmDde
 *
 * @param == Main Windows ==
 * @default
 *
 * @param Help
 * @desc The Window Skin file for the Help Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Gold
 * @desc The Window Skin file for the Gold Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Event Windows ==
 * @default
 *
 * @param Message
 * @desc The Window Skin file for the Message Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Choice List
 * @desc The Window Skin file for the Choice List Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Number Input
 * @desc The Window Skin file for the Number Input Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Event Item
 * @desc The Window Skin file for the Event Item Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Battle Windows ==
 * @default
 *
 * @param Party Command
 * @desc The Window Skin file for the Party Command Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Actor Command
 * @desc The Window Skin file for the Actor Command Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Battle Status
 * @desc The Window Skin file for the Battle Status Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Battle Actor
 * @desc The Window Skin file for the Battle Actor Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Battle Enemy
 * @desc The Window Skin file for the Battle Enemy Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Battle Skill
 * @desc The Window Skin file for the Battle Skill Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Battle Item
 * @desc The Window Skin file for the Battle Item Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Title Windows ==
 * @default
 *
 * @param Title Command
 * @desc The Window Skin file for the Title Command Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Menu Windows ==
 * @default
 *
 * @param Menu Command
 * @desc The Window Skin file for the Menu Command Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Menu Status
 * @desc The Window Skin file for the Menu Status Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Menu Actor
 * @desc The Window Skin file for the Menu Actor Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Item Windows ==
 * @default
 *
 * @param Item Category
 * @desc The Window Skin file for the Item Category Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Item List
 * @desc The Window Skin file for the Item List Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Skill Windows ==
 * @default
 *
 * @param Skill Type
 * @desc The Window Skin file for the Skill Type Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Skill Status
 * @desc The Window Skin file for the Skill Status Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Skill List
 * @desc The Window Skin file for the Skill List Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Equip Windows ==
 * @default
 *
 * @param Equip Status
 * @desc The Window Skin file for the Equip Status Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Equip Command
 * @desc The Window Skin file for the Equip Command Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Equip Slot
 * @desc The Window Skin file for the Equip Slot Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Equip Item
 * @desc The Window Skin file for the Equip Item Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Status Windows ==
 * @default
 *
 * @param Status
 * @desc The Window Skin file for the Status Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Options Windows ==
 * @default
 *
 * @param Options
 * @desc The Window Skin file for the Options Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == End Windows ==
 * @default
 *
 * @param Game End
 * @desc The Window Skin file for the Game End Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Shop Windows ==
 * @default
 *
 * @param Shop Command
 * @desc The Window Skin file for the Shop Command Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Shop Buy
 * @desc The Window Skin file for the Shop Buy Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Shop Sell
 * @desc The Window Skin file for the Shop Sell Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Shop Number
 * @desc The Window Skin file for the Shop Number Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Shop Status
 * @desc The Window Skin file for the Shop Status Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Name Windows ==
 * @default
 *
 * @param Name Edit
 * @desc The Window Skin file for the Name Edit Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Name Input
 * @desc The Window Skin file for the Name Input Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Save Windows ==
 * @default
 *
 * @param Save/Load List
 * @desc The Window Skin file for the Save/Load List Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Debug Windows ==
 * @default
 *
 * @param Debug Range
 * @desc The Window Skin file for the Debug Range Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Debug Edit
 * @desc The Window Skin file for the Debug Edit Window.
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param == Custom Windows ==
 * @default
 *
 * @param Custom Window 1
 * @desc The name of the Class for Custom Window 1. 
 * Use Custom Skin 1 to set the skin.
 * @default
 *
 * @param Custom Skin 1
 * @desc The file name for the Window Skin of Custom Window 1. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 2
 * @desc The name of the Class for Custom Window 2. 
 * Use Custom Skin 2 to set the skin.
 * @default
 *
 * @param Custom Skin 2
 * @desc The file name for the Window Skin of Custom Window 2. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 3
 * @desc The name of the Class for Custom Window 3. 
 * Use Custom Skin 3 to set the skin.
 * @default
 *
 * @param Custom Skin 3
 * @desc The file name for the Window Skin of Custom Window 3. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 4
 * @desc The name of the Class for Custom Window 4. 
 * Use Custom Skin 4 to set the skin.
 * @default
 *
 * @param Custom Skin 4
 * @desc The file name for the Window Skin of Custom Window 4. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 5
 * @desc The name of the Class for Custom Window 5. 
 * Use Custom Skin 5 to set the skin.
 * @default
 *
 * @param Custom Skin 5
 * @desc The file name for the Window Skin of Custom Window 5. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 6
 * @desc The name of the Class for Custom Window 6. 
 * Use Custom Skin 6 to set the skin.
 * @default
 *
 * @param Custom Skin 6
 * @desc The file name for the Window Skin of Custom Window 6. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 7
 * @desc The name of the Class for Custom Window 7. 
 * Use Custom Skin 7 to set the skin.
 * @default
 *
 * @param Custom Skin 7
 * @desc The file name for the Window Skin of Custom Window 7. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 8
 * @desc The name of the Class for Custom Window 8. 
 * Use Custom Skin 8 to set the skin.
 * @default
 *
 * @param Custom Skin 8
 * @desc The file name for the Window Skin of Custom Window 8. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 9
 * @desc The name of the Class for Custom Window 9. 
 * Use Custom Skin 9 to set the skin.
 * @default
 *
 * @param Custom Skin 9
 * @desc The file name for the Window Skin of Custom Window 9. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 10
 * @desc The name of the Class for Custom Window 10. 
 * Use Custom Skin 10 to set the skin.
 * @default
 *
 * @param Custom Skin 10
 * @desc The file name for the Window Skin of Custom Window 10. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 11
 * @desc The name of the Class for Custom Window 11. 
 * Use Custom Skin 11 to set the skin.
 * @default
 *
 * @param Custom Skin 11
 * @desc The file name for the Window Skin of Custom Window 11. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 12
 * @desc The name of the Class for Custom Window 12. 
 * Use Custom Skin 12 to set the skin.
 * @default
 *
 * @param Custom Skin 12
 * @desc The file name for the Window Skin of Custom Window 12. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 13
 * @desc The name of the Class for Custom Window 13. 
 * Use Custom Skin 13 to set the skin.
 * @default
 *
 * @param Custom Skin 13
 * @desc The file name for the Window Skin of Custom Window 13. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 14
 * @desc The name of the Class for Custom Window 14. 
 * Use Custom Skin 14 to set the skin.
 * @default
 *
 * @param Custom Skin 14
 * @desc The file name for the Window Skin of Custom Window 14. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 15
 * @desc The name of the Class for Custom Window 15. 
 * Use Custom Skin 15 to set the skin.
 * @default
 *
 * @param Custom Skin 15
 * @desc The file name for the Window Skin of Custom Window 15. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 16
 * @desc The name of the Class for Custom Window 16. 
 * Use Custom Skin 16 to set the skin.
 * @default
 *
 * @param Custom Skin 16
 * @desc The file name for the Window Skin of Custom Window 16. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 17
 * @desc The name of the Class for Custom Window 17. 
 * Use Custom Skin 17 to set the skin.
 * @default
 *
 * @param Custom Skin 17
 * @desc The file name for the Window Skin of Custom Window 17. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 18
 * @desc The name of the Class for Custom Window 18. 
 * Use Custom Skin 18 to set the skin.
 * @default
 *
 * @param Custom Skin 18
 * @desc The file name for the Window Skin of Custom Window 18. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 19
 * @desc The name of the Class for Custom Window 19. 
 * Use Custom Skin 19 to set the skin.
 * @default
 *
 * @param Custom Skin 19
 * @desc The file name for the Window Skin of Custom Window 19. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @param Custom Window 20
 * @desc The name of the Class for Custom Window 20. 
 * Use Custom Skin 20 to set the skin.
 * @default
 *
 * @param Custom Skin 20
 * @desc The file name for the Window Skin of Custom Window 20. 
 * Must be stored in /img/SumRndmDde/window/
 * @default
 *
 * @help
 * 
 * Individual Skins for Windows
 * Version 1.00
 * SumRndmDde
 *
 *
 * This Plugin allows you to customize the Window Skins for each individual
 * Window within your entire game.
 *
 * All of the Window Skins you wish to use need to be stored in:
 * /img/SumRndmDde/window/
 *
 * You can customize the Window Skin used by a certain Window by setting 
 * that specific Window in the Parameters to the file name of the 
 * Window Skin.
 *
 * If a Parameter is left blank, that Window will use the default 
 * Window Skin.
 *
 *
 * ==========================================================================
 *  End of Help File
 * ==========================================================================
 * 
 * Welcome to the bottom of the Help file.
 *
 *
 * Thanks for reading!
 * If you have questions, or if you enjoyed this Plugin, please check
 * out my YouTube channel!
 *
 * https://www.youtube.com/c/SumRndmDde
 *
 *
 * Until next time,
 *   ~ SumRndmDde
 */

var SRD = SRD || {};
SRD.IndividualSkinsForWindows = SRD.IndividualSkinsForWindows || {};

var Imported = Imported || {};
Imported["SumRndmDde Individual Skins for Windows"] = true;

(function(_) {

	_.skins = {
		Window_Help: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Help']),
		Window_Gold: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Gold']),
		Window_MenuCommand: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Menu Command']),
		Window_MenuStatus: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Menu Status']),
		Window_MenuActor: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Menu Actor']),
		Window_ItemCategory: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Item Category']),
		Window_ItemList: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Item List']),
		Window_SkillType: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Skill Type']),
		Window_SkillStatus: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Skill Status']),
		Window_SkillList: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Skill List']),
		Window_EquipStatus: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Equip Status']),
		Window_EquipCommand: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Equip Command']),
		Window_EquipSlot: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Equip Slot']),
		Window_EquipItem: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Equip Item']),
		Window_Status: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Status']),
		Window_Options: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Options']),
		Window_SavefileList: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Save/Load List']),
		Window_ShopCommand: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Shop Command']),
		Window_ShopBuy: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Shop Buy']),
		Window_ShopSell: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Shop Sell']),
		Window_ShopNumber: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Shop Number']),
		Window_ShopStatus: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Shop Status']),
		Window_NameEdit: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Name Edit']),
		Window_NameInput: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Name Input']),
		Window_ChoiceList: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Choice List']),
		Window_NumberInput: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Number Input']),
		Window_EventItem: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Event Item']),
		Window_Message: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Message']),
		Window_PartyCommand: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Party Command']),
		Window_ActorCommand: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Actor Command']),
		Window_BattleStatus: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Battle Status']),
		Window_BattleActor: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Battle Actor']),
		Window_BattleEnemy: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Battle Enemy']),
		Window_BattleSkill: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Battle Skill']),
		Window_BattleItem: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Battle Item']),
		Window_TitleCommand: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Title Command']),
		Window_GameEnd: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Game End']),
		Window_DebugRange: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Debug Range']),
		Window_DebugEdit: String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Debug Edit'])
	}

	for(var i = 1; i <= 20; i++) {
		var wind = String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Custom Window ' + i]);
		var skin = String(PluginManager.parameters('SRD_IndividualSkinsForWindows')['Custom Skin ' + i]);
		if(wind.trim().length > 0 && skin.trim().length > 0) {
			_.skins[wind] = skin;
		}
	}

	_.loadSumRndmDdeWindow = function(filename, hue) {
		return ImageManager.loadBitmap('img/SumRndmDde/window/', filename, hue, true);
	};

	var _Scene_Boot_create = Scene_Boot.prototype.create;
	Scene_Boot.prototype.create = function() {
		_Scene_Boot_create.call(this);
		for(var i in _.skins) {
			if(_.skins[i].trim().length > 0) {
				_.loadSumRndmDdeWindow(_.skins[i]);
			}
		}
	};

	var _Window_Base_loadWindowskin = Window_Base.prototype.loadWindowskin;
	Window_Base.prototype.loadWindowskin = function() {
		_Window_Base_loadWindowskin.call(this);
		if(_.skins[this.constructor.name]){
			this.windowskin = _.loadSumRndmDdeWindow(_.skins[this.constructor.name]);
		}
	};

})(SRD.IndividualSkinsForWindows);